package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/**
 * <p>
 * 材料名称：存储的文件的名称
 * 保存路径：存储的位置
 * 类型：为各个页面的附件建立一个代码区分（如人员信息里，有照片附件→ZPFJ，有档案文件→DAWJ）
 * 关联ID：存储附件对应的数据的主键（如照片附件对应的人员信息ID）
 * 关联ID2：存储附件对应的其他数据的主键（如照片附件对应的证件信息ID）
 * 若还有其他关联，可以增加关联ID3、关联ID4。。等
 *
 * </p>
 *
 * @author 黄宇
 * @since 2020-03-23
 */
@Data
@TableName("ZFRYGL_J_FJ")
public class FjVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 附件ID
     */
    @TableId
    private String fjId;

    /**
     * 附件名称（文件名）
     */
    private String clmc;

    /**
     * 附件路径
     */
    private String bclj;

    /**
     * 附件类型
     */
    private String lx;

    /**
     * 关联ID
     */
    private String glid;

    /**
     * 关联ID2
     */
    private String glid2;

    /**
     * 单位名称
     */
    private String dwmc;

    /**
     * 表外字段
     **/
    @TableField(exist = false)
    private String[] fjIdS;

    /**
     * 附件大小
     */
    @TableField(exist = false)
    private String fileSize;
    /**
     * 文件系统id
     */
    @TableField(exist = false)
    private String filekey;

    @TableField(exist = false)
    private String newFileName;
    /**
     * 时长-课件附件需要
     */
    @TableField(exist = false)
    private String sc;
    /**
     * 学分-课件附件需要
     */
    @TableField(exist = false)
    private String xf;
    /**
     * 音视频时长
     */
    @TableField(exist = false)
    private Integer spypsjsc;

    /**
     * 文件系统id
     */
    private String wjxtwjId;

    @Override
    public String getId() {
        return fjId;
    }

    @Override
    public void setId(String id) {
        this.fjId = id;
    }


}
