package com.kdgcsoft.jt.xzzf.dubbo.zfry.bak.common.entity;

import com.alibaba.fastjson.annotation.JSONField;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.io.Serializable;
import java.util.Date;

/**典型案卷实体类
 * @author huangyu
 */
@Data
public class DxAjInfoVO  implements Serializable {

    private static final long serialVersionUID = 1L;

    /**
     * 典型案卷ID
     */
    private String dxajId;

    /**
     * 考评记录表的唯一标识
     */
    private String kpjlbId;

    /**
     * 标记人姓名
     */
    private String bjr;

    /**
     * 标记人所在机构
     */
    private String zzjgid;

    /**
     * 组织机构名称
     */
    private String zzjgmc;

    /**
     * 标记时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date bjsj;

    /**
     * 标记为重点案卷的案件ID
     */
    private String ajxxId;

    /**
     * 案由
     */
    private String ay;

    /**
     * 执法机关名称
     */
    private String zfjgmc;

    /**
     * 案件状态
     */
    private String zt;
    /**
     * 车船号
     */
    private String cch;

    /**
     * 受案时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date sasj;

    /**
     * 行政决定时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date xzjdsj;

    /**
     * 结案时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jasj;
    /**
     * 工作流Id
     */
    private  String gzlId;



    /***页面查询条件**/

    /**
     * 案号
     */
    private String ah;
    /**
     * 行业代码
     */
    private String hydm;
    /**
     * 案件类型
     */
    private String ajlxdm;
    /**
     * 执法机关ID
     */
    private String zfjgid;
    /**
     * 查询范围
     */
    private String cxfw;
    /**
     * 当事人名称
     */
    private String dsrmc;
    /**
     * 受理受案日期
     */
    private String slsarqStart;
    /**
     * 受理受案日期
     */
    private String slsarqEnd;
    /**
     * 结案办结日期
     */
    private String jabjrqStart;
    /**
     * 结案办结日期
     */
    private String jabjrqEnd;
}
