package com.kdgcsoft.jt.xzzf.dubbo.zfgs.zxfb.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @description 资讯发布实体类
 * @version 1.0
 * @date 2020-05-30 13:55
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"ZFGS_J_ZFZX")
public class ZfzxVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 资讯发布主键
     */
    @TableId("ZFZXID")
    private String zfzxid;

    /**
     * 资讯发布查询条件字段————对接执法信息公示app接口
     */
    @TableField(exist = false)
    private String zxcx;

    /*****
     * 资讯标题
     */
    private String zxbt;

    /**
     * 资讯内容
     */
    private String zxnr;

    /*****
     * 发布日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date fbrq;

    /*****
     * 发布人
     */
    private String fbr;

    /*****
     * 发布人Id
     */
    @TableField("FBRID")
    private String fbrId;

    /*****
     * 发布单位
     */
    private String fbdw;

    /*****
     * 发布单位Id
     */
    @TableField("FBDWID")
    private String fbdwId;

    /*****
     * 发布状态:
     * 01:已发布
     * 02:待发布
     */
    private String fbzt;

    /*****
     * 执法资讯类别:
     * 01:执法资讯
     * 02:通知公告
     */
    private String zfzxlb;

    /*****
     * 公示期限类别
     * 01:不设期限
     * 02:设定期限
     */
    private String gsqxlb;

    /**
     * 公示截止日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date gsjzrq;

    /*****
     * 主图地址
     */
    private String ztdz;

    /*****
     * 主图名称
     */
    private String ztmc;

    /*****
     * 发布状态Text
     */
    @TableField(exist = false)
    private String fbztText;

    /*****
     * 公示期限类别Text
     */
    @TableField(exist = false)
    private String gsqxlbText;


    @Override
    public String getId() {
        return zfzxid;
    }

    @Override
    public void setId(String zfzxid) {
        this.zfzxid = zfzxid;
    }

}