package com.kdgcsoft.jt.xzzf.dubbo.zfgs.zmhd.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfgs.zmhd.entity.ZmhdYwclVo;

/****
 * @className ZmhdYwclService
 * @author ChrisYolanda
 * @description 政民互动处理单位管理服务层接口
 * @version 1.0
 * @date 2020-10-09 15:11
 */
public interface ZmhdYwclService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZmhdYwclVo> page(Page<ZmhdYwclVo> page, ZmhdYwclVo entity, String curUserOrgId);

    /*****
     * 保存政民互动处理单位数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user
     */
    void saveOrUpdate(ZmhdYwclVo entity, boolean isCreate, SysUser user);

    /*****
     * 获取政民互动处理单位数据信息
     * @param id 主键ID
     * @return
     */
    ZmhdYwclVo getEntityInfoById(String id);

    /******
     * 删除政民互动处理单位信息
     * @param ids 主键Id集合
     * @param user 　当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 获取政民互动处理单位数据信息
     * @param xzqhId 行政区划Id
     * @return
     */
    ZmhdYwclVo getEntityInfoByXzqhId(String xzqhId);
}
