package com.kdgcsoft.jt.xzzf.dubbo.zfgs.zmhd.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfgs.zmhd.entity.ZmhdVo;

import java.util.List;

/****
 * @className TsjbService
 * @author ChrisYolanda
 * @description 政民互动服务层接口
 * @version 1.0
 * @date 2020-08-24 10:51
 */
public interface ZmhdService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param zmhdlb 政民互动类别
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZmhdVo> page(Page<ZmhdVo> page, ZmhdVo entity, String zmhdlb, String curUserOrgId);

    /*****
     * 保存政民互动数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user
     */
    void saveOrUpdate(ZmhdVo entity, boolean isCreate, SysUser user);

    /*****
     * 获取政民互动数据信息
     * @param id 主键ID
     * @param zmhdlb 政民互动类别
     * @return
     */
    ZmhdVo getEntityInfoById(String id, String zmhdlb);

    /******
     * 删除政民互动信息
     * @param ids 主键Id集合
     * @param zmhdlb 政民互动类别
     * @param user 　当前登录用户
     */
    void deleteDataByIds(String ids, String zmhdlb, SysUser user);

    /*****
     * 修改政民互动状态
     * @param ids 主键Id集合
     * @param zmhdlb 政民互动类别
     * @param user 当前登录用户
     */
    void modifyPublishStatusDataByIds(String ids, String zmhdlb, SysUser user);

    /*****
     * 修改政民互动处理状态
     * @param ids 主键Id集合
     * @param status 处理状态
     * @param zmhdlb 政民互动类别
     * @param user 当前登录用户
     */
    void modifyHandleStatusDataByIds(String ids, String status, String zmhdlb, SysUser user);

    /*****
     * 转交政民互动数据
     * @param ids 主键Id集合
     * @param hfnr 回复内容
     * @param status 处理状态
     * @param zmhdlb 政民互动类别
     * @param user 当前登录用户
     */
    void transferDataByIds(String ids, String hfnr, String status, String zmhdlb, SysUser user);

    /******
     * 修改数据状态
     * @param zmhdId 主键Id
     * @param status 处理状态
     * @param user 当前登录用户
     */
    void updateEntityInfoStatus(String zmhdId, String status, SysUser user);

    /**
     * 首页中 政民互动数量统计
     *
     * @return
     * @Param zmhdlb 政民互动类别
     * @Param clzt 政民互动处理类别
     * @param startTime 开始时间
     * @param endTime 结束时间
     */
    Integer getCount(String zmhdlb, String clzt, String startTime, String endTime, String curUserOrgId);

    /**
     * 今日新增数量统计
     *
     * @return
     * @Param zmhdlb 政民互动类别
     */
    Integer getCountDay(String zmhdlb,String curUserOrgId);

    /**
     * 未处理数量统计
     *
     * @return
     * @Param zmhdlb 政民互动类别
     */
    Integer getNotCount(String zmhdlb,String curUserOrgId);

    /******
     * 统计政民互动总数
     * @param orgId 组织机构Id
     * @return
     */
    Integer getTotalCountByOrgId(String orgId);

    /**
     * 政民互动分配功能
     * @param ids 政民互动主键
     * @param zmhdlb 政民互动类别
     * @param zmhdVo 政民互动实体类
     * @param user 当前登录用户
     */
    void assign(String ids, String zmhdlb, ZmhdVo zmhdVo, SysUser user);

    /**
     * 政民互动查看处理状态
     * @param ids 政民互动主键
     * @param zmhdlb 政民互动类别
     * @param status 处理状态数组
     */
    List <ZmhdVo> clztSearch(String[] ids, String zmhdlb, String[] status);
}
