package com.kdgcsoft.jt.xzzf.dubbo.zfgs.zmhd.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.zfgs.zmhd.entity.ZmhdVo;

/****
 * @description 办件查询接口
 * @version 1.0
 * @date 2020-06-03 14:39
 */
public interface BjcxService {

    /**
     * 办件查询
     *
     * @return
     * @Param page 页面信息
     * @Param sfzh 身份证号
     * @Param xm 姓名
     */
    Page<ZmhdVo> pageSearch(Page<ZmhdVo> page, String sfzh, String xm);

    /**
     * 执法公示App接口  政民互动 投诉举报 01 办件查询
     *
     * @return
     * @Param page 页面信息
     * @Param sfzh 身份证号
     * @Param xm 姓名
     * @Param clzt 0未处理 1 处理中 2办结 3不予处理 null为查全部
     */
    Page<ZmhdVo> tsjbPageSearch(Page<ZmhdVo> page, String sfzh, String xm, String clzt);

    /**
     * 执法公示App接口  政民互动 意见建议 02 办件查询
     *
     * @return
     * @Param page 页面信息
     * @Param sfzh 身份证号
     * @Param xm 姓名
     * @Param clzt 0未回复 1已回复 null为查全部
     */
    Page<ZmhdVo> yjjyPageSearch(Page<ZmhdVo> page, String sfzh, String xm, String clzt);
    
    /**
     * 执法公示App接口  政民互动 信息资讯 03 办件查询
     *
     * @return
     * @Param page 页面信息
     * @Param sfzh 身份证号 必填
     * @Param xm 姓名
     * @Param clzt 处理状态
     */
    Page<ZmhdVo> xxzxPageSearch(Page<ZmhdVo> page, String sfzh, String xm, String clzt);

    /*
    办件查询 详细信息查询
     */
    ZmhdVo getZmhdById(String zmhdid);
}
