package com.kdgcsoft.jt.xzzf.dubbo.zfgs.zmhd.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className ZmhdYwclVo
 * @author ChrisYolanda
 * @description 政民互动处理单位实体类
 * @version 1.0
 * @date 2020-08-26 10:43
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS + "ZFGS_J_ZMHD_YWCLGLB")
public class ZmhdYwclVo extends BaseEntity<String> {

    /*****
     * 是否可分配
     * 01-可分配
     * 02-不可分配
     */
    public static final String ZMHDYWCL_DISTRIBUTE_TYPE_01 = "01";
    public static final String ZMHDYWCL_DISTRIBUTE_TYPE_02 = "02";

    /*****
     * 主键Id
     */
    @TableId("YWCLGLID")
    private String ywclglid;

    /*****
     * 行政区划Id
     */
    private String xzqhid;

    /*****
     * 行政区划编码
     */
    private String xzqhbm;

    /*****
     * 行政区划名称
     */
    private String xzqhmc;

    /*****
     * 组织机构Id
     */
    private String orgid;

    /*****
     * 组织机构编码
     */
    private String orgcode;

    /*****
     * 组织机构名称
     */
    private String orgname;

    /*****
     * 是否可分配
     * 01-可分配
     * 02-不可分配
     */
    private String distribute;

    /*****
     * 备注
     */
    private String remarks;

    @Override
    public String getId() {
        return ywclglid;
    }

    @Override
    public void setId(String id) {
        this.ywclglid = id;
    }
}
