package com.kdgcsoft.jt.xzzf.dubbo.zfgs.zmhd.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldFill;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/****
 * @description 政民互动实体类
 * @version 1.0
 * @date 2020-05-29 10:03
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS + "ZFGS_J_ZMHD")
public class ZmhdVo extends BaseEntity<String> {

    /*****
     * 互动类别
     * 01:投诉举报
     * 02:意见建议
     * 03:信息资讯
     */
    public static final String ZMHD_TYPE_01 = "01";
    public static final String ZMHD_TYPE_02 = "02";
    public static final String ZMHD_TYPE_03 = "03";

    /*****
     * 主键Id
     */
    @TableId("ZMHDID")
    private String zmhdid;

    /*****
     * 姓名
     */
    private String xm;

    /*****
     * 性别
     */
    private String xb;

    /*****
     * 联系电话
     */
    private String lxdh;

    /*****
     * 身份证号
     */
    private String sfzh;

    /*****
     * 联系地址
     */
    private String lxdz;

    /*****
     * 标题
     */
    private String bt;

    /*****
     * 内容
     */
    private String nr;

    /*****
     * 查询码
     */
    private String cxm;

    /*****
     * 政民互动类别
     * 01:投诉举报
     * 02:意见建议
     * 03:信息资讯
     */
    private String zmhdlb;

    /*****
     * 业务类别
     * 01:水路
     * 02:公路
     * 03:政策法规类
     * 04:建设执法
     */
    private String ywlb;

    /*****
     * 处理状态
     * 投诉举报:01-未处理;02-处理中;03-办结;04-不予处理;05-转交
     * 意见建议:01-未处理;02-处理中;03-办结;04-不予处理;
     * 信息咨询:01-未处理;02-处理中;03-办结;04-不予处理;
     */
    private String clzt;

    /*****
     * 发布状态
     * 01-已发布
     * 02-未发布
     */
    private String fbzt;

    /*****
     * 数据来源
     * 01-公众投诉录入
     * 02-系统录入
     */
    private String sjly;

    /*****
     * 行政区划Id
     */
    private String xzqhid;

    /*****
     * 行政区划名称
     */
    private String xzqhmc;

    /*****
     * 发布单位Id
     */
    private String fbdwid;

    /*****
     * 发布单位名称
     */
    private String fbdw;

    /*****
     * 处理单位id
     */
    private String cldwid;

    /*****
     * 处理单位名称
     */
    private String cldw;

    /*****
     * 提交日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date tjrq;

    /*****
     * 性别Text
     */
    @TableField(exist = false)
    private String xbText;

    /*****
     * 业务类别Text
     */
    @TableField(exist = false)
    private String ywlbText;

    /*****
     * 处理状态Text
     */
    @TableField(exist = false)
    private String clztText;

    /*****
     * 发布状态Text
     */
    @TableField(exist = false)
    private String fbztText;

    /*****
     * 数据来源Text
     */
    @TableField(exist = false)
    private String sjlyText;

    /*****
     * 是否可分配
     * 01-可分配
     * 02-不可分配
     */
    @TableField(exist = false)
    private String distribute;

    /*****
     * 是否可分配Text
     */
    @TableField(exist = false)
    private String distributeText;

    /*****
     * 主键集合
     */
    @TableField(exist = false)
    private String[] ids;

    /*****
     * 历史记录信息
     */
    @TableField(exist = false)
    private List<ZmhdHisVo> zmhdHisList = new ArrayList<>();

    /**
     * 验证码
     */
    @TableField(exist = false)
    private String yzm;

    /**
     * 回复单位ID
     */
    @TableField(exist = false)
    private String hfdwid;

    /**
     * 首页年份
     */
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy")
    @JsonFormat(pattern = "yyyy", timezone = "GMT+8")
    private String searchyear;

    /**
     * 回复人
     */
    @TableField(exist = false)
    private String hfr;

    /**
     * 回复内容
     */
    @TableField(exist = false)
    private String hfnr;

    /**
     * 回复时间
     */
    @TableField(exist = false)
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date hfsj;

    /**
     * 回复单位
     */
    @TableField(exist = false)
    private String hfdw;


    @Override
    public String getId() {
        return zmhdid;
    }

    @Override
    public void setId(String id) {
        this.zmhdid = id;
    }
}