package com.kdgcsoft.jt.xzzf.dubbo.zfgs.zmhd.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @description 政民互动处理实体类
 * @version 1.0
 * @date 2020-06-03 11:20
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"ZFGS_J_ZMHD_HIS")
public class ZmhdHisVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 政民互动处理主键
     */
    @TableId("HISID")
    private String hisid;

    /*****
     * 政民互动主键Id
     */
    @TableField("ZMHDID")
    private String zmhdId;

    /**
     * 回复人
     */
    private String hfr;

    /**
     * 回复内容
     */
    private String hfnr;

    /**
     * 回复单位
     */
    private String hfdw;

    /**
     * 回复单位id
     */
    private String hfdwid;

    /**
     * 回复人id
     */
    private String hfrid;

    /**
     * 回复时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss", timezone = "GMT+8")
    private Date hfsj;

    /**
     * 来信时间
     */
    @TableField(exist = false)
    private String lxsj;

    @Override
    public String getId() {
        return hisid;
    }

    @Override
    public void setId(String zmhdclid) {
        this.hisid = hisid;
    }
}