package com.kdgcsoft.jt.xzzf.dubbo.zfgs.zfsj.service;

import com.kdgcsoft.jt.xzzf.dubbo.zfgs.zfsj.entity.UserInfo;

/****
 * @className UserInfoService
 * @author Administrator
 * @description 用户信息接口
 * @version 1.0
 * @date 2020-06-11 09:40
 */
public interface UserInfoService {

    /**
     * 获取用户信息
     *
     * @param userId 用户id
     * @return
     */
    UserInfo getUserInfoByUserId(String userId);

    /**
     * 新增用户信息
     *
     * @param userInfo 用户
     * @return
     */
    void insertUserInfo(UserInfo userInfo);

    /**
     * 修改用户信息
     *
     * @param userInfo 用户
     * @return
     */
    boolean updateById(UserInfo userInfo);

    /**
     * 根据userId删除用户信息
     *
     * @param userId 用户id
     * @return
     */
    boolean deleteById(String userId);

}
