package com.kdgcsoft.jt.xzzf.dubbo.zfgs.zfsj.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className AppInfo
 * @author zhoupeng
 * @description 执法公示app信息
 * @version 1.0
 * @date 2020-09-18 17:05
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"ZFGS_J_APPINFO")
public class ZfgsAppInfo extends BaseEntity<String> {

    /****
     * 主键ID
     */
    @TableId
    private String id;

    /**
     * 执法公示app版本号
     */
    private String zfgsAppVersion;

    /**
     * app版本号
     */
    private String AppVersion;

    /**
     * appid
     */
    private String appid;

    /**
     * 添加时间
     */
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date createTime;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}
