package com.kdgcsoft.jt.xzzf.dubbo.zfgs.zfsj.entity;

import cn.hutool.core.date.DatePattern;
import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className UserInfo
 * @author zhoupeng
 * @description 用户信息实体类
 * @version 1.0
 * @date 2020-06-11 10:20
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"ZFGS_J_USERINFO")
public class UserInfo extends BaseEntity<String> {

    /****
     * 主键ID
     */
    @TableId
    private String id;

    /**
     * 用户id
     */
    private String userId;

    /**
     * 当前登录的个人用户的真实姓名/法定代表人姓名
     */
    private String userName;

    /**
     * 账号类型0：个人 1：法人 (如果是子账户登录，该字段值为1)
     */
    private String acType;

    /**
     * 是否是子账号，true：是子账户，false：不是子账户
     */
    private String isSubType;

    /**
     * 01:省平台用户 02:国家个人用户 03:国家法人用户
     */
    private String nationType;

    /**
     * 用户账号名
     */
    private String account;

    /**
     * 认证等级
     * 0	未认证
     * 1	初级认证
     * 2	中级认证
     * 3	高级认证
     * 9	港澳台海外待实名
     * 10	海外待实名
     */
    private String certificationLevel;

    /**
     * 性别
     * 未知	0
     * 男	1
     * 女	2
     */
    private String sex;

    /**
     * 民族
     */
    private String nation;

    /**
     * 当前登录的个人用户绑定的手机号(法定代表人手机号)
     */
    private String bindPhone;

    /**
     * 用户头像地址
     */
    private String headImgurl;

    /**
     * 证件类型
     * 身份证	0
     * 护照	1
     * 台湾居民来往大陆通行证	2
     * 港澳居民来往内地通行证	3
     * 外国人永久居留证	4
     */
    private String credentType;

    /**
     * 个人用户--证件号码，对应credentType类型/法人用户--法人证件号码
     */
    private String credentNo;

    /**
     * 国籍
     */
    private String nationality;


    /**
     * 法人用户---法定代表人证件类型
     * 01	组织机构代码证
     * 02	工商营业执照
     * 03	统一信用代码
     * 04	注册登记证件
     */
    private String identityType;
    /**
     * 法人用户---法定代表人的证件号码，对应identityType类型
     */
    private String identityNo;

    /**
     * 法人用户---工商注册号码
     */
    private String registCode;

    /**
     * 法人用户---法定代表人注册地址
     */
    private String legalUserAdress;

    /**
     * 法人用户---法人成立日期，格式yyyyMMdd
     */
    private String foundTime;

    /**
     * 法人用户---法人联系电话（基本为空）
     */
    private String telephone;

    /**
     * 法人用户---法人邮箱
     */
    private String email;

    /**
     * 法人用户---单位类型
     * 机构编制事业单位	12
     * 机构编制群众团体	13
     * 机构编制其他	19
     * 机构编制机关	11
     * 民政社会团体	51
     * 民政民办非企业单位	52
     * 民政基金会	53
     * 民政其他	59
     * 工商企业	91
     * 工商个体工商户	92
     * 工商农民专业合作社	93
     * 其他	Y1
     * 筹建中机构	0
     */
    private String orgType;

    /**
     * 法人用户---单位名称
     */
    private String orgName;

    /**
     * 法人用户---统一社会信用代码  addressDetail
     */
    private String uscCode;

    /**
     * 法人用户---法人注册地址
     */
    private String addressDetail;

    /**
     * 登录时间
     */
    @DateTimeFormat(pattern = DatePattern.NORM_DATE_PATTERN)
    @JSONField(format = DatePattern.NORM_DATETIME_PATTERN)
    private Date loginTime;

    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }
}
