package com.kdgcsoft.jt.xzzf.dubbo.zfgs.ycydcl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zfgs.ycydcl.entity.JsyxxVo;

import java.util.List;

/****
 * @description 远程异地执法车主信息---驾驶员信息绑定（用于执法公示app）
 * @version 1.0
 * @date 2020/10/13 14:13
 */
public interface JsyxxbdService {

    /*****
     * 保存驾驶员信息
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user
     */
//    void saveOrUpdate(JsyxxVo entity, boolean isCreate, SysUser user);

    /*****
     * 查看驾驶员信息
     * @param zjhm 证件号码
     */
    JsyxxVo getJsyxxByZjhm(String zjhm);

    /*****
     * 通过手机号获取驾驶员信息
     * @param jsylxdh 手机号码
     */
    JsyxxVo getJsyxxBySjhm(String jsylxdh);

    /*****
     * 驾驶员信息分页查询--对接协同办案系统
     * @param current
     * @param size
     * @param entity 实体类
     * @return
     */
    Page<JsyxxVo> page(long current, long size, JsyxxVo entity);

    /*****
     * 创建驾驶员信息
     * @param entity 实体类
     */
    void createJsyxx(JsyxxVo entity,SysUser user);

    /*****
     * 保存驾驶员信息
     * @param entity 实体类
     * @param user
     */
    void updateJsyxxById(JsyxxVo entity, SysUser user);

    /*****
     * 查看驾驶员信息
     * @param id 证件号码
     */
    JsyxxVo getJsyxxById(String id);

    /*****
     * 修改驾驶员信息
     * @param entity 实体类
     * @param user
     */
    void updateJsyxx(JsyxxVo entity, SysUser user);

    /*****
     * 删除驾驶员信息
     */
    void deleteJsyxx(String userId);

    /*****
     * 判断身份证号码是否已经重复注册
     * @param entity 注册信息
     */
    Integer getSfzhNumber(JsyxxVo entity);

}
