package com.kdgcsoft.jt.xzzf.dubbo.zfgs.ycydcl.service;

import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @description 远程异地执法车主信息---驾驶员材料（附件上传）（用于执法公示app）
 * @version 1.0
 * @date 2020/10/13 14:13
 */
public interface JsyclService {
    /*******
     * 保存相关附件的信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     * @param cllx 材料类型
     * @param details 附件内容
     * @param user 当前用户
     */
    public void saveOrUpdate(String ywbId, String ywbMc,String cllx, String details, SysUser user);

    /******
     * 获取附件列表信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     * @param cllx 材料类型
     * @return
     */
    public List<AttachmentVo> queryEntityListInfoByYwbIdAndYwbMc(String ywbId, String ywbMc,String cllx);

    /******
     * 物理删除附件相关信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     * @param cllx 材料类型
     */
    public void deleteEntityInfoByYwbIdAndYwbMc(String ywbId, String ywbMc,String cllx);
}
