package com.kdgcsoft.jt.xzzf.dubbo.zfgs.ycydcl.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @description 远程异地执法车主信息上报---信息通知（用于执法公示app）
 * @version 1.0
 * @date 2020/10/13 14:08
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"YCYDZF_XXTZ")
public class XxtzVo extends BaseEntity<String> {
    private static final long serialVersionUID = 1L;

    /**
     * 主键 唯一 信息id
     */
    @TableId("XXID")
    private String xxid;

    /**
     * 信息标题
     */
    private String xxbt;

    /**
     * 信息内容
     */
    private String xxnr;

    /**
     * 接收人证件类型
     * 01--个人
     * 02--企业
     */
    private String zjlx;

    /**
     * 接收人证件号码
     */
    private String zjhm;

    /**
     * 车牌号码
     */
    private String cphm;

    /**
     * 接收人手机号码
     */
    private String sjhm;

    /**
     * 发送时间
     */
    private String fssj;

    /**
     * 是否已读
     */
    private String sfyd;

    /**
     * 接收人证件类型文本值
     */
    @TableField(exist = false)
    private String zjlxText;

    @Override
    public String getId() {
        return xxid;
    }

    @Override
    public void setId(String xxid) {
        this.xxid = xxid;

    }
}
