package com.kdgcsoft.jt.xzzf.dubbo.zfgs.ycydcl.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/****
 * @description 远程异地执法车主信息--驾驶员信息（用于执法公示app）
 * @version 1.0
 * @date 2020/10/13 14:13
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"YCYDCL_JSYXXBD")
public class JsyxxVo extends BaseEntity<String> {
    private static final long serialVersionUID = 1L;


    /*****
     * 材料类型
     * 01:统一社会信用代码
     * 02:驾驶证件
     * 03:行驶证件
     * 04:道路运输证
     */
    public static final String CLLX_TYPE_01 = "01";
    public static final String CLLX_TYPE_02 = "02";
    public static final String CLLX_TYPE_03 = "03";
    public static final String CLLX_TYPE_04 = "04";

    /**
     * 主键 唯一
     */
    @TableId
    private String userId;

    /**
     * 证件号码
     */
    private String zjhm;
    /**
     * 证件类型
     * 身份证-0
     * 护照-1
     * 台湾居民来往大陆通行证-2
     * 港澳居民来往内地通行证-3
     * 外国人永久居留证-4
     */
    private String zjlx;

    /**
     * 车牌号码
     */
    private String cphm;

    /**
     * 发动机后六位
     */
    private String fdjhlw;

    /**
     * 驾驶证号
     */
    private String jszh;

    /**
     * 行驶证号
     */
    private String xszh;

    /**
     * 驾驶员类型
     * 01--个人
     * 02--企业
     */
    private String jsylx;

    /**
     * 驾驶员联系电话
     */
    private String jsylxdh;

    /**
     * 统一社会信用代码
     */
    private String tyshxydm;

    /**
     * 绑定时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date bdsj;

    /**
     * 道路运输证
     */
    private String dlysz;

    /**
     * 驾驶员姓名
     */
    private String xm;

    /*****
     * 证件
     */
    @TableField(exist = false)
    private String certs;

    /**
     * 附件List信息(后台往前台传--统一社会信用代码)
     */
    @TableField(exist = false)
    public List<AttachmentVo> attachListTyshxydm = new ArrayList<>();

    /**
     * 附件List信息(后台往前台传--驾驶证件)
     */
    @TableField(exist = false)
    public List<AttachmentVo> attachListJszj = new ArrayList<>();

    /**
     * 附件List信息(后台往前台传--行驶证件)
     */
    @TableField(exist = false)
    public List<AttachmentVo> attachListXszj = new ArrayList<>();

    /**
     * 附件List信息(后台往前台传--道路运输证)
     */
    @TableField(exist = false)
    public List<AttachmentVo> attachListDlysz = new ArrayList<>();

    /**
     * 证件类型文本值
     */
    @TableField(exist = false)
    private String zjlxText;

    /**
     * 驾驶员类型--文本
     */
    @TableField(exist = false)
    private String jsylxText;

    @Override
    public String getId() {
        return userId;
    }

    @Override
    public void setId(String zjhm) {
        this.userId = userId;
    }
}
