package com.kdgcsoft.jt.xzzf.dubbo.zfgs.ycydcl.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @description 远程异地执法车主信息--驾驶员材料（证件附件信息）信息（用于执法公示app）
 * @version 1.0
 * @date 2020/10/13 14:09
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"YCYDCL_JSYCL")
public class JsyclVo extends BaseEntity<String> {
    private static final long serialVersionUID = 1L;

    /**
     *  唯一 材料id
     */
    @TableId
    private String clid;

    /**
     * 材料类型  (业务表数据中的分类)
     * 01-统一社会信用代码
     * 02-驾驶证
     * 03-行驶证
     */
    private String cllx;

    /**
     * 相关附件名称
     */
    private String fjmc;

    /**
     * 相关附件路径
     */
    private String fjlj;

    /**
     * 业务表名称
     */
    private String ywbmc;

    /**
     * 业务表主键
     */
    private String ywbzj;

    /**
     * 附件类型
     */
    private String fjlx;

    /**
     * 附件原名称
     */
    private String fjymc;

    /**
     * 附件类别
     */
    private String fjlb;

    @Override
    public String getId() {
        return clid;
    }

    @Override
    public void setId(String clid) {
        this.clid = clid;

    }
}
