package com.kdgcsoft.jt.xzzf.dubbo.zfgs.szgs.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * 事中公示实体类
 * @author cgd
 * @since 2020-05-13
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"ZFGS_J_SZGS")
public class SzgsVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 事中公示主键
     */
    @TableId("SZGSID")
    private String szgsid;

    /*****
     * 标题
     */
    private String bt;

    /**
     * 公示内容
     */
    private String nr;

    /*****
     * 发布人
     */
    private String fbr;

    /*****
     * 发布人Id
     */
    @TableField("FBRID")
    private String fbrId;

    /*****
     * 发布单位
     */
    private String fbdw;

    /*****
     * 发布单位Id
     */
    @TableField("FBDWID")
    private String fbdwId;

    /*****
     * 公示期限类别:
     * 01:不设期限
     * 02:设定期限
     */
    private String gsqxlb;

    /**
     * 公示截止日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date gsjzrq;

    /*****
     * 发布日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date fbrq;

    /**
     * 所属地市
     */
    private String ssds;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /*****
     * 事中公示类别:
     * 01:表明执法人员身份
     * 02:当事人权利义务
     * 03:执法窗口岗位
     * 04:执法检测站点
     */
    private String szgslb;

    /*****
     * 公示状态:
     * 01:未公示
     * 02:已公示
     */
    private String gszt;

    /*****
     * 公示状态Text
     */
    @TableField(exist = false)
    private String gsztText;

    /*****
     * 公示期限类别Text
     */
    @TableField(exist = false)
    private String gsqxlbText;

    @Override
    public String getId() {
        return szgsid;
    }

    @Override
    public void setId(String szgsid) {
        this.szgsid = szgsid;
    }

}
