package com.kdgcsoft.jt.xzzf.dubbo.zfgs.sqgs.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 *  事前公示
 * @author wsl
 * @since 2020-05-18
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"ZFGS_J_SQGS")
public class SqgsVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 事前公示主键 唯一 不能为null
     */
    @TableId("SQGSID")
    private String sqgsid;

    /*****
     * 标题
     */
    private String bt;

    /*****
     * 发布日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date fbrq;

    /*****
     * 发布人
     */
    private String fbr;

    /*****
     * 发布人Id
     */
    @TableField("FBRID")
    private String fbrId;

    /*****
     * 发布单位
     */
    private String fbdw;

    /*****
     * 发布单位Id
     */
    @TableField("FBDWID")
    private String fbdwId;

    /*****
     * 公示期限类别
     * 01:不设期限
     * 02:设定期限
     */
    private String gsqxlb;

    /**
     * 公示截止日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date gsjzrq;

    /*****
     * 事前公示类别:
     * 01:主体信息
     * 02:职责信息
     * 03:依据信息
     * 04:程序信息
     * 05:清单信息
     * 06:监督信息
     * 07:其它信息
     */
    private String sqgslb;

    /*****
     * 公示状态:
     * 01:未公示
     * 02:已公示
     */
    private String gszt;

    /**
     * 所属地市
     */
    private String ssds;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /**
     * 公示内容
     */
    private String nr;

    /*****
     * 公示状态Text
     */
    @TableField(exist = false)
    private String gsztText;

    /*****
     * 公示期限类别Text
     */
    @TableField(exist = false)
    private String gsqxlbText;

    @Override
    public String getId() {
        return sqgsid;
    }

    @Override
    public void setId(String sqgsid) {
        this.sqgsid = sqgsid;
    }


}
