package com.kdgcsoft.jt.xzzf.dubbo.zfgs.shgs.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.zfgs.shgs.entity.SjgsVO;

import java.util.List;

/****
 * @description 执法数据公示服务层接口
 * @author 徐文静
 * @version 1.0
 * @date 2020-05-27 09:39
 */
public interface SjgsService {

    /**
     * 执法数据分页查询
     *
     * @param current 当前页
     * @param size    数据数量
     * @param xzqhdm  行政区划代码
     * @return
     */
    Page<SjgsVO> zfsjSearchPage(long current, long size, String xzqhdm);

    /**
     * 根据zfgssjid查询执法数据详情
     *
     * @return
     * @Param zfgssjid
     */
    SjgsVO getZfsjById(String zfgssjid);

    /**
     * 首页 最新的执法数据查询
     * @return
     */
    List<SjgsVO> searchPageLately();
}
