package com.kdgcsoft.jt.xzzf.dubbo.zfgs.shgs.entity;


import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * @author wsl
 * @since 2020-06-05
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_XTBA + "XTBA_J_QZCSSJ")
public class ZfqzgsVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;
    /**
     * 行政执法强制公示主键
     */
    @TableId("XZQZGSID")
    private String xzqzgsid;
    /**
     * 行政相对人名称
     */
    private String xzxdrmc;
    /**
     * 行政相对人类别
     */
    private String xzxdrlb;
    /**
     * 统一社会信用代码
     */
    private String tyshxydm;
    /**
     * 工商注册号
     */
    private String gszch;
    /**
     * 组织机构代码
     */
    private String zzjgdm;
    /**
     * 税务登记号
     */
    private String swdjh;
    /**
     * 事业单位证书号
     */
    private String sydwzsh;
    /**
     * 社会组织登记证书号
     */
    private String shzzdjzsh;
    /**
     * 法定代表人 名称
     */
    private String fddbr;
    /**
     * 法定代表人证件类型
     */
    private String fddbrzjlx;
    /**
     * 法定代表人证件号码
     */
    private String fddbrzjhm;
    /**
     * 证件类型
     */
    private String zjlx;
    /**
     * 证件号码
     */
    private String zjhm;
    /**
     * 行政处罚决定书文号
     */
    private String xzqzjdswh;
    /**
     * 行政强制类别
     */
    private String xzqzlb;

    /*****
     * 行政强制类别Text
     */
    @TableField(exist = false)
    private String xzqzlbText;
    /**
     * 行政强制种类
     */
    private String xzqzzl;
    /**
     * 行政强制依据
     */
    private String qzyj;
    /**
     * 强制内容
     */
    private String qznr;

    /**
     * 强制决定日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date qzjdrq;
    /**
     * 强制有效期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date qzyxq;
    /**
     * 公示截止期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date gsjzq;

    /**
     * 处罚机关
     */
    private String cfjg;


    /**
     * 处罚机关统一社会信用代码
     */
    private String cfjgtyshxydm;

    /**
     * 数据来源单位
     */
    private String sjlydw;


    /**
     * 数据来源单位统一社会信用代码
     */
    private String sjlydwtyshxydm;


    /**
     * 地方编码
     */
    private String dfbm;

    /**
     * 备注
     */
    private String bz;


    /**
     * 所属地市
     */
    private String ssds;
    /**
     * 行政区划代码
     */
    private String xzqhdm;


    /**
     * 违法事实
     */
    private String wfss;

    /**
     * 违法行为类型
     */
    private String wfxwlx;
    /**
     * 公示状态
     */
    private String gszt;

    /*****
     * 强制机构Id
     */
    private String qzjgId;

    /******
     * 强制机关名称
     */
    @TableField(exist = false)
    private String qzjgName;


    @Override
    public String getId() {
        return xzqzgsid;
    }

    @Override
    public void setId(String id) {
        this.xzqzgsid = xzqzgsid;
    }


}
