package com.kdgcsoft.jt.xzzf.dubbo.zfgs.shgs.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 * 事后公示/行政许可公示  行政许可公示实体类 -- 对应数据中心的数据库 表名：ODS_LAW_CFXK.XZXK_XYXX
 * 实体类
 * </p>
 *
 * @author 王帅龙
 * @since 2020-06-08
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_XZSP + "XZXK_XYXX")
public class XzxkgsVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;
    /*****
     * 主键Id
     */
    @TableId("ID")
    private String id;

    /*****
     * 行政相对人名称
     */
    private String xkXdr;


    /*****
     * 行政相对人类别
     */
    private String xkXdrLb;

    /*****
     * 统一社会信用代码  行政相对人社会信用代码
     */
    private String xkXdrShxym;

    /*****
     * 工商注册号
     */
    private String xkXdrGsdj;

    /*****
     * 组织机构代码
     */
    private String xkXdrZdm;

    /*****
     * 行政相对人税务登记号 xkXdrSwdj
     */
    private String xkXdrSwdj;

    /*****
     * 事业单位证书号
     */
    private String xkXdrSydw;

    /*****
     * 社会组织登记证书号
     */
    private String xkXdrShzz;

    /*****
     * 法定代表人
     */
    private String xkFr;

    /*****
     * 法定代表人证件类型
     */
    private String xkFrZjlx;

    /*****
     * 法定代表人证件号码
     */
    private String xkFrSfzh;

    /*****
     * 证件类型
     */
    private String xkXdrZjlx;

    /*****
     * 证件号码
     */
    private String xkXdrSfz;

    /*****
     *  行政许可决定书名称
     */
    private String xkXmmc;

    /*****
     * 行政许可决定文书号
     */
    private String xkWsh;

    /*****
     * 许可类别
     */
    private String xkSplb;

    /*****
     * 许可证书名称
     */
    private String xkXkzs;

    /*****
     * 许可编号
     */
    private String xkXkbh;

    /*****
     * 许可内容
     */
    private String xkNr;

    /*****
     * 许可决定日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date xkJdrq;

    /*****
     * 有效期开始日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date xkYxqz;

    /*****
     * 有效期截止日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date xkJzq;

    /*****
     * 许可机关名称
     */
    private String xkXzjg;

    /*****
     * 许可机关统一社会信用码
     */
    private String xkXkjgdm;

    /*****
     * 当前状态 XK_ZT 状态
     */
    private String xkZt;

    /*****
     * 数据来源单位名称
     */
    private String xkLydw;

    /*****
     * 数据来源单位统一社会信用代码  数据来源单位社会信用代码
     */
    private String xkLydwdm;

    /*****
     * 地方编码 == 行政区划
     */
    private String dfbm;

    /*****
     * 备注
     */
    private String bz;

    /*****
     * 时间戳+1
     */
    private String sjc;

    /*****
     * 公开状态
     * 0公开
     * 1暂缓公开
     * 2不公开  默认0
     */
    private String gkzt;

    /*****
     * ODS数据交换交换时间 XYPT_TIME_DXP
     */
    private String xyptTimeDxp;

    /*****
     * 变更标识 CHANGE_FLAG
     * 1新增
     * 2变更
     * 3删除+1   默认1
     */
    private String changeFlag;

    /*****
     * 公示状态Text
     */
    @TableField(exist = false)
    private String gkztText;


    @Override
    public String getId() {
        return id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    /*****
     *  CREATE_DATE
     */
    private String createDate;

    /*****
     *  UPDATE_DATE
     */
    private String updateDate;

    /*****
     *  SYNC_FLAG
     */
    private String syncFlag;

    /*****
     *  DO_FLAG
     */
    private String doFlag;

    /*****
     * 案号 AN_HAO
     */
    private String anHao;

    /*****
     * 申请人 SHEN_QING_REN
     */
    private String shenQingRen;

    /*****
     * 申请日期 SHEN_QING_RI_QI
     */
    private String shenQingRiQi;

    /*****
     *  许可结果XU_KE_JIE_GUO
     */
    private String xuKeJieGuo;

    /*****
     * 顺序号 SHUN_XU_HAO
     */
    private String shunXuHao;

    /*****
     *  办结时间BAN_JIE_SHI_JIAN
     */
    private String banJieShiJian;

    /*****
     *  SEND_FLAG
     */
    private String sendFlag;

    /*****
     * 联系电话 LIANXI_DIAN_HUA
     */
    private String lianxiDianHua;

}
