package com.kdgcsoft.jt.xzzf.dubbo.zfgs.shgs.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/**
 * <p>
 *  行政检查公示
 * </p>
 *
 * @author wsl
 * @since 2020-05-27
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"ZFGS_J_XZJCGS")
public class XzjcgsVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;
    /**
     * 行政检查公示主键
     */
    @TableId("XZJCGSID")
    private String xzjcgsid;
    /*****
     * 标题
     */
    private String bt;

    /*****
     * 发布日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date fbrq;

    /*****
     * 发布人
     */
    private String fbr;

    /*****
     * 发布人Id
     */
    @TableField("FBRID")
    private String fbrId;

    /*****
     * 发布单位
     */
    private String fbdw;

    /*****
     * 发布单位Id
     */
    @TableField("FBDWID")
    private String fbdwId;

    /*****
     * 公示期限类别
     * 01:不设期限
     * 02:设定期限
     */
    private String gsqxlb;

    /**
     * 公示截止日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    @TableField(updateStrategy = FieldStrategy.IGNORED)
    private Date gsjzrq;

    /*****
     * 公示状态:
     * 01:已公示
     * 02:未公示
     * 03:已撤销
     */
    private String gszt;

    /**
     * 所属地市
     */
    private String ssds;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /**
     * 公示内容
     */
    private String nr;

    /***
     * 检查任务明细id（数据来源于协同办案）具有唯一性
     */
    private String jcrwmxid;

    /***
     * 检查任务id（数据来源于协同办案）不具有唯一性
     */
    private String jcrwid;

    /***
     * 数据来源（01 执法公示后台 02 协同办案）
     */
    private String sjly;

    /*****
     * 公示状态Text
     */
    @TableField(exist = false)
    private String gsztText;

    /*****
     * 公示期限类别Text
     */
    @TableField(exist = false)
    private String gsqxlbText;

    /**
     * 发布日期别名
     */
    @TableField(exist = false)
    private String rq;


    @Override
    public String getId() {
        return xzjcgsid;
    }

    @Override
    public void setId(String xzjcid) {
        this.xzjcgsid = xzjcgsid;
    }


}

