package com.kdgcsoft.jt.xzzf.dubbo.zfgs.shgs.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.sql.Date;

/**
 *
 * @author wsl
 * @since 2020-05-29
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_XTBA + "XTBA_J_AJXX")
public class XzcfgsVo extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;
    /*****
     * 主键Id
     */
    @TableId("ID")
    private String id;

    /*****
     * 行政相对人名称 CF_XDR_MC
     */
    private String cfXdrMc;

    /*****
     * 行政相对人类别 CF_XDR_LB
     */
    private String cfXdrLb;

    /*****
     * 统一社会信用代码 CF_XDR_SHXYM
     */
    private String cfXdrShxym;

    /*****
     * 工商注册号  CF_XDR_GSDJ
     */
    private String cfXdrGsdj;

    /*****
     * 组织机构代码 CF_XDR_ZDM
     */
    private String cfXdrZdm;

    /*****
     * 税务登记号 CF_XDR_SWDJ
     */
    private String cfXdrSwdj;

    /*****
     * 事业单位证书号 CF_XDR_SYDW
     */
    private String cfXdrSydw;

    /*****
     * 社会组织登记证书号  CF_XDR_SHZZ
     */
    private String cfXdrShzz;

    /*****
     * 法定代表人名称 CF_FR
     */
    private String cfFr;

    /*****
     * 法定代表人证件类型  CF_FR_ZJLX
     */
    private String cfFrZjlx;

    /*****
     * 法定代表人证件号码  CF_FR_SFZH
     */
    private String cfFrSfzh;

    /*****
     * 证件类型  CF_XDR_ZJLX
     */
    private String cfXdrZjlx;

    /*****
     * 证件号码 CF_XDR_SFZ
     */
    private String cfXdrSfz;

    /*****
     * 行政处罚决定书文号  CF_WSH
     */
    private String cfWsh;

    /*****
     * 违法行为类型  CF_WFXW
     */
    private String cfWfxw;

    /*****
     * 违法事实 CF_SY
     */
    private String cfSy;

    /*****
     * 处罚依据 CF_YJ
     */
    private String cfYj;

    /*****
     * 处罚类别 CF_CFLB1
     */
    private String cfCflb1;

    /*****
     * 处罚结果（内容） CF_JG
     */
    private String cfJg;

    /*****
     * 罚款金额  CF_NR_FK 单位 （万元）
     */
    private BigDecimal cfNrFk;

    /*****
     * 没收违法所得、没收非法财物的金额（万元）  CF_NR_WFFF
     */
    private BigDecimal cfNrWfff;

    /*****
     * 暂扣或吊销证照名称及编号 CF_NR_ZKDX
     */
    private String cfNrZkdx;

    /*****
     * 处罚决定日期 CF_JDRQ
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date cfJdrq;

    /*****
     * 处罚有效日期  CF_YXQ
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date cfYxq;

    /*****
     * 公示截止日期  CF_GSJZQ
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date cfGsjzq;

    /*****
     * 处罚机关名称  CF_XZJG
     */
    private String cfXzjg;

    /*****
     * 处罚机关统一社会信用代码  CF_CFJGDM
     */
    private String cfCfjgdm;

    /*****
     * 数据来源单位编码 CF_SJLY
     */
    private String cfSjly;

    /*****
     * 数据来源单位统一社会信用代码  CF_SJLYDM
     */
    private String cfSjlydm;

    /*****
     * 地方编码 DFBM
     */
    private String dfbm;

    /*****
     * 备注 BZ
     */
    private String bz;

    /*****
     *  处罚名称  CF_CFMC
     */
    private String cfCfmc;

    /*****
     * ODS数据交换交换时间 XYPT_TIME_DXP
     */
    private String xyptTimeDxp;

    /*****
     * 公开状态:  GKZT
     * 0：公开、
     * 1：暂缓公开、
     * 2：不公开，默认为0
     */
    private String gkzt;

    /*****
     * 变更标识 CHANGE_FLAG
     * 1新增
     * 2变更
     * 3删除+1   默认1
     */
    private String changeFlag;

    /*****
     * 公开状态Text
     */
    @TableField(exist = false)
    private String gkztText;


    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public void setId(String id) {
        this.id = id;
    }

    /*****
     *  CREATE_DATE
     */
    private String createDate;

    /*****
     *  UPDATE_DATE
     */
    private String updateDate;

    /*****
     *  SYNC_FLAG
     */
    private String syncFlag;

    /*****
     *  DO_FLAG
     */
    private String doFlag;

    /*****
     * 案号 AN_HAO
     */
    private String anHao;

    /*****
     * 当事人 DANG_SHI_REN
     */
    private String dangShiRen;

    /*****
     *  立案时间LI_AN_SHI_JIAN
     */
    private String liAnShiJian;

    /*****
     *  结案时间  JIE_AN_SHI_JIAN
     */
    private String jieAnShiJian;

    /*****
     *  固化标准  GU_HUA_BIAO_ZHUN
     */
    private String guHuaBiaoZhun;

    /*****
     *  时间流水号  SHI_JIAN_LIU_SHUI_HAO
     */
    private String shiJianLiuShuiHao;

    /*****
     *  SEND_FLAG
     */
    private String sendFlag;

    /*****
     * 公示期限 CF_GSQX
     */
    private String cfGsqx;


}
