package com.kdgcsoft.jt.xzzf.dubbo.zfgs.shgs.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.FieldStrategy;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @description 执法数据公示实体类
 * @version 1.0
 * @date 2020-05-27 09:12
 */
@Data
@TableName(DataSourceConstant.DATA_SOURCE_ZFGS +"ZFGS_J_ZFSJGS")
public class SjgsVO extends BaseEntity<String> {

    private static final long serialVersionUID = 1L;

    /**
     * 数据公示主键
     */
    @TableId("ZFGSSJID")
    private String zfgssjid;

    /**
     * 标题
     */
    private String bt;

    /**
     * 发布人姓名
     */
    private String fbr;

    /**
     *发布人Id
     */
    private String fbrid;

    /**
     * 发布单位名称
     */
    private String fbdw;

    /**
     * 发布单位id
     */
    private String fbdwid;

    /**
     * 发布日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date fbrq;

    /*****
     * 公示期限类别
     * 01:不设期限
     * 02:设定期限
     */
    private String gsqxlb;

    /**
     * 公示截止日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    @TableField(updateStrategy  = FieldStrategy.IGNORED)
    private Date gsjzrq;

    /**
     * 内容
     */
    private String nr;

    /**
     * 所属地市
     */
    private String ssds;

    /**
     * 行政区划代码
     */
    private String xzqhdm;

    /**
     * 公示状态
     * 01 已公示
     * 02 未公示
     */
    private String gszt;

    @Override
    public String getId() {
        return zfgssjid;
    }

    @Override
    public void setId(String zfgssjid) {
        this.zfgssjid = zfgssjid;
    }

}