package com.kdgcsoft.jt.xzzf.dubbo.zfgs.pub.service;

import com.kdgcsoft.jt.xzzf.common.component.AttachmentVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;

import java.util.List;

/****
 * @description 附件服务接口
 * @version 1.0
 * @date 2020-05-19 09:54
 */
public interface XgfjService {

    /*******
     * 保存相关附件的信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     * @param details 附件内容
     * @param user 当前用户
     */
    public void saveOrUpdate(String ywbId, String ywbMc, String details, SysUser user);

    /******
     * 获取附件列表信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     * @return
     */
    public List<AttachmentVo> queryEntityListInfoByYwbIdAndYwbMc(String ywbId, String ywbMc);

    /******
     * 物理删除附件相关信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     */
    public void deleteEntityInfoByYwbIdAndYwbMc(String ywbId, String ywbMc);

    /*****
     * 逻辑删除附件相关信息
     * @param ywbId 相关业务表Id
     * @param ywbMc 相关业务表名称
     * @param user 当前用户
     */
    public void logicDeleteEntityInfoByYwbIdAndYwbMc(String ywbId, String ywbMc, SysUser user);

}
