package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfzb.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.rest.Result;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfzb.entity.ZfzblbVo;

import java.util.List;
import java.util.Map;

/****
 * @className ZfzblbService
 * @author hufanghua
 * @description 执法装备类别Service接口层接口
 * @version 1.0
 * @date 2020-06-16 15:03
 */
public interface ZfzblbService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    public Page<ZfzblbVo> page(Page<ZfzblbVo> page, ZfzblbVo entity);

    /*****
     * 保存或修改执法装备类别数据
     * @param entity 实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(ZfzblbVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取执法装备类别
     * @param id 主键ID
     * @return
     */
    public ZfzblbVo getEntityInfoById(String id);

    /*****
     * 删除执法装备类别
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /*****
     * 执法装备类别下拉框数据
     * @param filter 关键字过滤
     * @return
     */
    public List<ComboboxVo> queryEntityCombobox(String filter);

    /******
     * 导入Excel
     * @param dataList
     * @param user
     */
    public Result importExcel(List<Map<String, Object>> dataList,SysUser user);
}
