package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfzb.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfzb.entity.ZfzbxxdjVo;

import java.util.List;
import java.util.Map;

/****
 * @className ZfzbdjService
 * @author hufanghua
 * @description 执法装备登记Service接口层接口
 * @version 1.0
 * @date 2020-06-17 15:03
 */
public interface ZfzbdjService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param orgId 登录人所在机构
     * @return
     */
    public Page<ZfzbxxdjVo> page(Page<ZfzbxxdjVo> page, ZfzbxxdjVo entity,String orgId);

    /*****
     * 保存或修改执法装备信息数据
     * @param entity 车辆实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(ZfzbxxdjVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取执法装备信息
     * @param id 主键ID
     * @return
     */
    public ZfzbxxdjVo getEntityInfoById(String id);

    /*****
     * 删除执法装备信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /***
     * 根据装备编号查询装备信息
     * @param zbbh
     * @return
     */
    public ZfzbxxdjVo getEntityInfoByZbbh(String zbbh);

    /***
     * 根据装备主键查询装备状态日志信息
     * @param id 车辆主键
     * @return
     */
    public List<ZfzbxxdjVo> queryZbztrz(String id);

    /******
     * 获取总数
     * @param zblbId 装备类别Id
     * @return
     */
    public Integer getTotalCountByZblbId(String zblbId);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);

    /*****
     * 根据id更新管理负责人
     * @param entity 装备实体类
     * @return
     */
    public void updateGlfzr(ZfzbxxdjVo entity, SysUser user);

    /*****
     * 查询装备状态图表数据
     * @param orgId 单位id
     * @param flag 是否查询子机构标识
     * @return
     */
    public List<ZfzbxxdjVo> queryZbztEchart(String orgId,String flag);

    /*****
     * 查询装备类型图表数据
     * @param orgId 单位id
     * @param flag 是否查询子机构标识
     * @return
     */
    public List<ZfzbxxdjVo> queryZblxEchart(String orgId,String flag);

    /*****
     * 查询装备技术状况图表数据
     * @param orgId 单位id
     * @param flag 是否查询子机构标识
     * @return
     */
    public List<ZfzbxxdjVo> queryZbjszkEchart(String orgId,String flag);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<ZfzbxxdjVo> export(ZfzbxxdjVo entity, String ids, String curUserOrgId);

    /*****
     * 查询装备类型今年新增数量
     * @param orgId 单位id
     * @param flag 是否查询子机构标识
     * @return
     */
    public List<ZfzbxxdjVo> queryZblxCount(String orgId,String flag);

    /*****
     * 查询执法装备数量
     * @param orgId 单位id
     * @param flag 是否查询子机构标识
     * @return
     */
    public ZfzbxxdjVo queryZfzbCount(String orgId,String flag);

}
