package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfzb.entity;

import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.fasterxml.jackson.annotation.JsonFormat;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfzbztVo
 * @author hufanghua
 * @description 执法装备状态实体
 * @version 1.0
 * @date 2020-06-17 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFZB_ZFZBZT")
public class ZfzbztVo extends BaseEntity<String> {

    /***
     * 装备状态编号
     */
    @TableId("ZBZTBH")
    private String zbztbh;

    /******
     * 装备信息登记ID
     */
    private String zbxxdjid;

    /******
     * 装备编号
     */
    private String zbbh;

    /******
     * 装备状态参数ID
     */
    private String zbztcsid;

    /******
     * 装备状态
     */
    private String zbzt;

    /******
     * 记录日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date jlrq;

    /******
     * 记录人
     */
    private String jlr;

    /******
     * 车辆类型备注
     */
    private String bz;

    @Override
    public String getId() {
        return this.zbztbh;
    }

    @Override
    public void setId(String id) {
        this.zbztbh = id;
    }
}
