package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfzb.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZfzbxxdjVo
 * @author hufanghua
 * @description 执法车辆信息实体类
 * @version 1.0
 * @date 2020-06-16 10:18
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFZB_ZFZBXXDJ")
public class ZfzbxxdjVo extends BaseEntity<String> {
    /******
     * 装备信息登记ID
     */
    @TableId("ZBXXDJID")
    private String zbxxdjid;

    /******
     * 执法装备状态主键
     */
    @TableField(exist = false)
    private String zbztbh;

    /******
     * 执法车辆ID
     */
    private String zfclid;

    /******
     * 执法装备类别ID
     */
    private String zfzblbid;

    /******
     * 装备编号
     */
    private String zbbh;

    /******
     * 所属单位
     */
    private String ssdw;

    /******
     * 所属单位id
     */
    private String ssdwid;

    /******
     * 装备类别
     */
    private String zblb;

    /******
     * 装备名称
     */
    private String zbmc;

    /******
     * 规格型号
     */
    private String ggxh;

    /******
     * 装备单价
     */
    private String zbdj;

    /******
     * 技术状况
     */
    private String jszk;

    /******
     * 技术状况文本值
     */
    @TableField(exist = false)
    private String jszkText;

    /******
     * 资金来源
     */
    private String zjly;

    /******
     * 资金来源文本值
     */
    @TableField(exist = false)
    private String zjlyText;

    /******
     * 数量
     */
    private String sl;

    /******
     * 车牌号码
     */
    private String cphm;

    /******
     * 使用部门
     */
    private String sybm;

    /******
     * 使用部门id
     */
    private String sybmid;

    /******
     * 管理负责人
     */
    private String glfzr;

    /******
     * 管理负责人id
     */
    private String glfzrid;

    /******
     * 购置日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date gzrq;

    /******
     * 报废日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date bfrq;

    /******
     * 变更
     */
    private String bg;

    /******
     * 登记人
     */
    private String djr;

    /******
     * 登记日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date djrq;

    /******
     * 备注
     */
    private String bz;

    /******
     * 装备状态参数ID
     */
    @TableField(exist = false)
    private String zbztcsid;

    /******
     * 装备状态
     */
    @TableField(exist = false)
    private String zbzt;

    /******
     * 备注
     */
    @TableField(exist = false)
    private String zbztbz;

    /******
     * 执法车辆登记-根据车牌号码准确查询关联设备情况
     */
    @TableField(exist = false)
    private String zfclCphm;

    /******
     * 上传附件详情
     */
    @TableField(exist = false)
    private String attachmentDetail;

    /******
     * 库存状态
     */
    @TableField(exist = false)
    private String kczt;

    /******
     * 数量统计
     */
    @TableField(exist = false)
    private String count;

    @Override
    public String getId() {
        return this.zbxxdjid;
    }

    @Override
    public void setId(String id) {
        this.zbxxdjid = id;
    }
}
