package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfzb.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZbpfjghxxbVo
 * @author hufanghua
 * @description 执法装备配发及归还信息实体
 * @version 1.0
 * @date 2020-06-16 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFZB_ZBPFJGHXXB")
public class ZbpfjghxxbVo extends BaseEntity<String> {

    /***
     * 装备配发及归还信息ID
     */
    @TableId("ZBPFJGHXXID")
    private String zbpfjghxxid;

    /******
     * 装备信息登记ID
     */
    private String zbxxdjid;

    /******
     * 领用单位名称
     */
    private String lydwmc;

    /******
     * 领用单位ID
     */
    private String lydwid;

    /******
     * 领用人
     */
    private String lyr;

    /******
     * 配发日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date pfrq;

    /******
     * 配发登记人
     */
    private String pfdjr;

    /******
     * 归还人
     */
    private String ghr;

    /******
     * 归还日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date ghrq;

    /******
     * 归还登记人
     */
    private String ghdjr;

    @Override
    public String getId() {
        return this.zbpfjghxxid;
    }

    @Override
    public void setId(String id) {
        this.zbpfjghxxid = id;
    }
}
