package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfzb.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className ZbkcztrzVo
 * @author hufanghua
 * @description 执法装备库存状态日志实体
 * @version 1.0
 * @date 2020-06-16 09:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFZB_ZBKCZTRZ")
public class ZbkcztrzVo extends BaseEntity<String> {

    /***
     * 装备库存状态日志ID
     */
    @TableId("ZBKCZTRZID")
    private String zbkcztrzid;

    /******
     * 装备信息登记ID
     */
    private String zbxxdjid;

    /******
     * 记录日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jlrq;

    /******
     * 库存状态
     */
    private String kczt;

    @Override
    public String getId() {
        return this.zbkcztrzid;
    }

    @Override
    public void setId(String id) {
        this.zbkcztrzid = id;
    }
}
