package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity.ZffzplVo;

import java.util.List;
import java.util.Map;

/****
 * @className ZffzplService
 * @author chris
 * @description 执法服装品类服务层接口
 * @version 1.0
 * @date 2020-06-04 18:16
 */
public interface ZffzplService {

    /*****
     * 执法服装品类分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZffzplVo> page(Page<ZffzplVo> page, ZffzplVo entity, String curUserOrgId);

    /*****
     * 执法人员已申领的执法服装品类分页查询
     * @param page 分页信息
     * @param zfryId 执法人员Id
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZffzplVo> zfryFzplPage(Page<ZffzplVo> page, String zfryId, ZffzplVo entity, String curUserOrgId);

    /*****
     * 首次申领登记执法服装品类信息分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZffzplVo> sldjFzplPage(Page<ZffzplVo> page, ZffzplVo entity, String curUserOrgId);

    /*****
     * 保存执法服装品类数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user
     */
    void saveOrUpdate(ZffzplVo entity, boolean isCreate, SysUser user);

    /******
     * 验证执法服装品类名称信息
     * @param zffzmcid 执法服装名称Id
     * @return
     */
    boolean verifyDataByFzmcIdAndRootOrgId(String zffzmcid);

    /*****
     * 获取执法服装品类信息
     * @param id 主键ID
     * @return
     */
    ZffzplVo getEntityInfoById(String id);

    /*****
     * 删除执法服装品类信息
     * @param ids 主键Id集合
     * @param user
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 查询执法服装品类下拉框的键值对
     * @param filter 关键字过滤
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Map<String, Object> queryEntityComboboxWithMap(String filter, String curUserOrgId);

    /*****
     * 获取当前执法服装品类的下一个序号
     * @return
     */
    Integer getFzplNextOrderNo();

    /******
     * 获取执法服装品类红薯
     * @param fzmcId 服装名称Id
     * @return
     */
    Integer getTotalCountByZffzmcId(String fzmcId);

    /******
     * @param dataList
     * @param user
     * @return
     */
    ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);

    /****
     *  执法服装品类下拉框
     * @param orgId
     * @return
     */
    List<ComboboxVo> queryZffzpl (String orgId);
}
