package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.component.ComboboxVo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity.ZffzmcVo;

import java.util.List;

/****
 * @className ZffzmcService
 * @author ChrisYolanda
 * @description 执法服装名称服务层接口
 * @version 1.0
 * @date 2020-09-11 10:34
 */
public interface ZffzmcService {

    /*****
     * 执法服装名称分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZffzmcVo> page(Page<ZffzmcVo> page, ZffzmcVo entity, String curUserOrgId);

    /*****
     * 保存执法服装名称数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user
     */
    void saveOrUpdate(ZffzmcVo entity, boolean isCreate, SysUser user);

    /*****
     * 获取执法服装名称信息
     * @param id 主键ID
     * @return
     */
    ZffzmcVo getEntityInfoById(String id);

    /*****
     * 删除执法服装名称信息
     * @param ids 主键Id集合
     * @param user
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 执法服装名称下拉框数据
     * @param filter 关键字过滤
     * @param lzzffl 路政制服分类
     * @return
     */
    List<ComboboxVo> queryEntityCombobox(String filter, String lzzffl);

    /*****
     * 根据制服分类获取执法服装名称信息
     * @param zffzmc 服装名称
     * @param zffl 制服分类
     * @return
     */
    ZffzmcVo getEntityInfoByZffl(String zffzmc,String zffl);

    /*****
     * 根据品类名称获取执法服装名称信息
     * @param zffzmc 服装名称
     * @return
     */
    ZffzmcVo getEntityInfoByFzmc(String zffzmc);
}
