package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity.RzryfzsldjmxVo;

import java.util.List;

/****
 * @className RzryfzsldjmxService
 * @author chris
 * @description 入职人员服装申领登记明细服务层接口
 * @version 1.0
 * @date 2020-06-15 15:06
 */
public interface RzryfzsldjmxService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<RzryfzsldjmxVo> page(Page<RzryfzsldjmxVo> page, RzryfzsldjmxVo entity);

    /*****
     * 列表查询
     * @param entity 实体类
     * @return
     */
    List<RzryfzsldjmxVo> dataList(RzryfzsldjmxVo entity);

    /*****
     * 列表查询
     * @param zfryId 执法人员Id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<RzryfzsldjmxVo> queryZfryFzslDataListByZfryId(String zfryId, String curUserOrgId);

    /********
     * 保存入职申领明细信息
     * @param sldjId 申领申领登记Id
     * @param detailInfo 申领明细信息
     * @param user 当前登录用户
     */
    void saveOrUpdate(String sldjId, String detailInfo, SysUser user);

    /********
     * 保存入职申领明细信息
     * @param sldjId 申领申领登记Id
     * @param fzplIds 服装品类Id集合
     * @param user 当前登录用户
     */
    void saveOrUpdates(String sldjId, String fzplIds, SysUser user);

    /*******
     * 逻辑删除入职申领登记明细信息
     * @param sldjId 申领申领登记Id
     * @param user 当前登录用户
     */
    void deleteLogicEntityInfoBySldjId(String sldjId, SysUser user);

    /******
     * 获取总数
     * @param fzplId 服装品类Id
     * @return
     */
    Integer getTotalCountByZffzplId(String fzplId);

    /*****
     * 获取入职人员服装申领登记明细信息
     * @param id 主键ID
     * @return
     */
    RzryfzsldjmxVo getEntityInfoById(String id);
}
