package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.api.entity.ZffzSldjZfryVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity.RzryfzsldjVo;

/****
 * @className RzryfzsldjService
 * @author chris
 * @description 入职人员服装申领登记服务层接口
 * @version 1.0
 * @date 2020-06-15 14:22
 */
public interface RzryfzsldjService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<RzryfzsldjVo> page(Page<RzryfzsldjVo> page, RzryfzsldjVo entity, String curUserOrgId);

    /*****
     * 获取已进行服装申领的执法人员分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<ZffzSldjZfryVo> zfryPageData(Page<ZffzSldjZfryVo> page, ZffzSldjZfryVo entity, String curUserOrgId);

    /*****
     * 保存入职人员服装申领登记数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user 当前登录用户
     */
    void saveOrUpdate(RzryfzsldjVo entity, boolean isCreate, SysUser user);

    /*****
     * 批量保存入职人员服装申领登记信息
     * @param zfryIds 执法人员Id集合
     * @param fzplIds 服装品类Id集合
     * @param jhpfnf 计划配发年份
     * @param user 当前登录用户
     * @return
     */
    void saveOrUpdates(String zfryIds, String fzplIds, String jhpfnf, SysUser user);

    /*****
     * 获取入职人员服装申领登记信息
     * @param id 主键ID
     * @return
     */
    RzryfzsldjVo getEntityInfoById(String id);

    /******
     * 获取申领信息总数
     * @param zfryId 执法人员Id
     * @return
     */
    Integer getApplyInfoCountByZfryId(String zfryId);

    /*****
     * 删除入职人员服装申领登记信息
     * @param ids 主键Id集合
     * @param user
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 判断申请信息
     * @param zfryId 执法人员Id
     * @param sldjId 入职申领登记Id
     * @return
     */
    boolean checkApplyInfo(String zfryId, String sldjId);

    /********
     * 停止服装配发
     * @param sldjId 入职申领登记Id
     * @param tzpfyy 停止配发原因
     * @param user 当前登录用户
     */
    void stopFzff(String sldjId, String tzpfyy, SysUser user);
}
