package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity.FzyssbdjVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity.FzyssbspVo;

/****
 * @className FzyssbspService
 * @author ChrisYolanda
 * @description 执法服装预算申报审批服务层接口
 * @version 1.0
 * @date 2020-09-23 18:00
 */
public interface FzyssbspService {

    /*****
     * 保存服装预算申报信息
     * @param applyInfo 服装预算申报信息
     * @param user 当前登录用户
     */
    void saveApplyInfo(FzyssbdjVo applyInfo, SysUser user);

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<FzyssbspVo> pageData(Page<FzyssbspVo> page, FzyssbspVo entity, String curUserOrgId);

    /*****
     * 获取执法服装预算申报登记审核信息
     * @param id 主键ID
     * @return
     */
    FzyssbspVo getEntityInfoById(String id);

    /*****
     * 获取执法服装预算申报登记审核信息
     * @param entity 实体类
     * @param user 当前登录用户
     * @return
     */
    void audit(FzyssbspVo entity, SysUser user);
}
