package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity.FzyssbdjVo;

/****
 * @className FzyssbdjService
 * @author ChrisYolanda
 * @description 执法服装预算申报登记服务层接口
 * @version 1.0
 * @date 2020-09-23 17:59
 */
public interface FzyssbdjService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<FzyssbdjVo> pageData(Page<FzyssbdjVo> page, FzyssbdjVo entity, String curUserOrgId);

    /*****
     * 保存执法服装预算申报登记数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user 当前登录用户
     */
    void saveOrUpdate(FzyssbdjVo entity, boolean isCreate, SysUser user);

    /*****
     * 申报执法服装预算申报登记数据
     * @param entity 实体类
     * @param isCreate 是否创建
     * @param user 当前登录用户
     */
    void apply(FzyssbdjVo entity, boolean isCreate, SysUser user);

    /*****
     * 获取执法服装预算申报登记信息
     * @param id 主键ID
     * @return
     */
    FzyssbdjVo getEntityInfoById(String id);

    /*****
     * 删除执法服装预算申报登记信息
     * @param ids 主键Id集合
     * @param user 当前登录用户
     */
    void deleteDataByIds(String ids, SysUser user);

    /*****
     * 获取执法服装预算申报登记信息
     * @param sbbh 申报编号
     * @return
     */
    FzyssbdjVo getEntityInfoBySbbh(String sbbh);

    /******
     * 更新审批状态和申报状态
     * @param sbzt 申报状态
     * @param spzt 审批状态
     * @param id 主键Id
     * @param user 当前登录用户
     */
    void updateEntitySbztAndSpztInfoById(String sbzt, String spzt, String id, SysUser user);
}
