package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity.FzsjpfxxVo;

import java.util.List;

/****
 * @className FzsjpfxxService
 * @author chris
 * @description 服装实际配发信息服务层接口
 * @version 1.0
 * @date 2020-06-20 14:48
 */
public interface FzsjpfxxService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<FzsjpfxxVo> page(Page<FzsjpfxxVo> page, FzsjpfxxVo entity, String curUserOrgId);

    /*****
     * 保存执法服装品类数据
     * @param details 实体类集合
     * @param   isCreate 是否创建
     * @param   pfnf 配发年份
     * @param user
     */
    void saveOrUpdate(String details, String pfnf, boolean isCreate, SysUser user);

    /*****
     * 获取执法服装品类信息
     * @param id 主键ID
     * @return
     */
    FzsjpfxxVo getEntityInfoById(String id);

    /*****
     * 删除服装实际配发信息
     * @param ids 主键Id集合
     * @param fzpfxqmxids 服装配发需求明细Id集合
     * @param user
     */
    void deleteDataByIds(String ids,String fzpfxqmxids, SysUser user);

    /******
     * 获取实际配发总数
     * @param zfryId 执法人员Id
     * @param pflxType 配发类型
     * @param pfnf 配发年份
     * @return
     */
    Integer getEntityInfoTotalCountByZfryIdAndPflxTypeAndPfnf(String zfryId, String pflxType, String pfnf);

    /*****
     * 修改服装实际配发信息
     * @param details 服装实际配发实体集合
     * @param user
     */
    void updateDataByIds(String details, SysUser user);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<FzsjpfxxVo> export(FzsjpfxxVo entity, String ids, String curUserOrgId);
}
