package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity.FzpfxqmxVo;

import java.util.List;

/****
 * @className FzpfxqmxService
 * @author chris
 * @description 服装配发需求明细服务层接口
 * @version 1.0
 * @date 2020-06-20 14:47
 */
public interface FzpfxqmxService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<FzpfxqmxVo> page(Page<FzpfxqmxVo> page, FzpfxqmxVo entity, String curUserOrgId);

    /******
     * 保存服装配发需求明细信息
     * @param entity 服装配发需求明细实体类
     * @param user 当前登录用户
     */
    void saveOrUpdate(FzpfxqmxVo entity, SysUser user);

    /********
     * 删除服装配发需求明细信息
     * @param headId 来源表主键Id
     * @param headName 来源表名称
     * @param headType 配发类型
     */
    void deleteEntityInfoByHeadIdAndHeadNameAndHeadType(String headId, String headName, String headType);

    /******
     * 逻辑删除服装配发需求明细信息
     * @param zfryId 执法人员Id
     * @param pflxType 配发类型
     * @param pfnf 配发年份
     * @param user 当前登录用户
     */
    void deleteLogicEntityInfoByZfryIdAndPflxTypeAndPfnf(String zfryId, String pflxType, String pfnf, SysUser user);

    /******
     * 删除服装配发需求明细信息
     * @param zfryId 执法人员Id
     * @param pflxType 配发类型
     * @param pfnf 配发年份
     */
    void deleteEntityInfoByZfryIdAndPflxTypeAndPfnf(String zfryId, String pflxType, String pfnf);

    /******
     * 获取总数
     * @param fzplId 服装品类Id
     * @return
     */
    Integer getTotalCountByZffzplId(String fzplId);

    /*****
     * 获取服装配发需求明细信息
     * @param id 主键ID
     * @return
     */
    FzpfxqmxVo getEntityInfoById(String id);

    /******
     * 修改配发状态
     * @param zfryId 执法人员Id
     * @param pflxType 配发类型
     * @param user 当前登录用户
     */
    void stopFzff(String zfryId, String pflxType, SysUser user);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param status 导出类型
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<FzpfxqmxVo> export(FzpfxqmxVo entity, String ids, int status, String curUserOrgId);

    /******
     * 保存服装配发需求明细信息(到期更换)
     * @param entity 服装配发需求明细实体类
     */
    void save(FzpfxqmxVo entity);

    /*****
     * 配发需求汇总分页-主页面查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<FzpfxqmxVo> pfxqhzManagerPage(Page<FzpfxqmxVo> page, FzpfxqmxVo entity, String curUserOrgId);

    /*****
     * 配发需求汇总分页-汇总弹框页面查询
     * @param page 分页信息
     * @param entity 实体类
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    Page<FzpfxqmxVo> pfxqhzFormPage(Page<FzpfxqmxVo> page, FzpfxqmxVo entity, String curUserOrgId);

    /*****
     * 查询配发需求明细数据根据执法人员id
     * @param zfryid 执法人员id
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    List<FzpfxqmxVo> queryPfxqmxByZfryid(String zfryid, String curUserOrgId);

    /********
     * 保存配发需求明细信息
     * @param sldjId 申领登记信息Id
     * @param djmxId 申领登记明细信息Id
     * @param user 当前登录用户信息
     */
    void saveFzpfxqmxInfoBySldjIdAndDjmxId(String sldjId, String djmxId, SysUser user);
}

