package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity.FzbfsldjmxVo;

import java.util.List;

/****
 * @className FzbfsldjmxService
 * @author chris
 * @description 服装补发申领登记明细服务层接口
 * @version 1.0
 * @date 2020-06-20 14:46
 */
public interface FzbfsldjmxService {

    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    Page<FzbfsldjmxVo> page(Page<FzbfsldjmxVo> page, FzbfsldjmxVo entity);

    /*****
     * 列表查询
     * @param entity 实体类
     * @return
     */
    List<FzbfsldjmxVo> dataList(FzbfsldjmxVo entity);

    /********
     * 保存补发申领明细信息
     * @param bfdjId 补发申领登记Id
     * @param zfryId 执法人员Id
     * @param detailInfo 申领明细信息
     * @param user 当前登录用户
     */
    void saveOrUpdate(String bfdjId, String zfryId, String detailInfo, SysUser user);

    /*******
     * 逻辑删除补发申领登记明细信息
     * @param bfdjId 补发申领登记Id
     * @param user 当前登录用户
     */
    void deleteLogicEntityInfoByBfdjId(String bfdjId, SysUser user);

    /******
     * 获取总数
     * @param fzplId 服装品类Id
     * @return
     */
    Integer getTotalCountByZffzplId(String fzplId);
}
