package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity;

import com.alibaba.excel.annotation.ExcelProperty;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className ZffzplVo
 * @author chris
 * @description 执法服装品类实体类
 * @version 1.0
 * @date 2020-06-04 17:58
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFFZ_ZFFZPL")
public class ZffzplVo extends BaseEntity<String> {

    public static final String ZFFZPL_SOURCE_TYPE_01 = "01";
    public static final String ZFFZPL_SOURCE_TYPE_02 = "02";

    /***
     * 执法服装品类ID
     */
    @TableId("ZFFZPLID")
    private String zffzplid;

    /******
     * 执法服装名称Id
     */
    private String zffzmcid;

    /******
     * 组织机构Id
     */
    private String orgId;

    /******
     * 执法服装品类名称
     */
    @ExcelProperty(value = "品类名称", index = 1)
    private String zffzplmc;

    /******
     * 路政制服分类:0:制服;1:装具
     */
    private String lzzffl;

    /******
     * 首次标配数量
     */
    @ExcelProperty(value = "首次标配数量")
    private String scbpsl;

    /******
     * 更换标准年限
     */
    @ExcelProperty(value = "更换标准年限")
    private String ghbznx;

    /******
     * 更换标准数量
     */
    @ExcelProperty(value = "更换标准数量")
    private String ghbzsl;

    /******
     * 计量单位
     */
    @ExcelProperty(value = "计量单位")
    private String jldw;

    /******
     * 是否列为公用： 0：否;1：是
     */
    private String sflwgy;

    /******
     * 来源方式:01-厅级,02-各个单位
     */
    private String sourceType;

    /******
     * 备注
     */
    private String bz;

    /****
     * 路政制服分类Text
     */
    @TableField(exist = false)
    @ExcelProperty(index = 2)
    private String lzzfflText;

    /****
     * 是否列为公用Text
     */
    @TableField(exist = false)
    @ExcelProperty(value = "是否公用")
    private String sflwgyText;

    /****
     * 组织机构名称
     */
    @TableField(exist = false)
    @ExcelProperty(value = "登记单位", index = 0)
    private String orgName;

    @Override
    public String getId() {
        return this.zffzplid;
    }

    @Override
    public void setId(String id) {
        this.zffzplid = id;
    }
}
