package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className RzryfzsldjVo
 * @author chris
 * @description 入职人员服装申领登记实体类
 * @version 1.0
 * @date 2020-06-15 13:57
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFFZ_RZRYFZSLDJ")
public class RzryfzsldjVo extends BaseEntity<String> {

    /***
     * 入职申领ID
     */
    @TableId("RZSLID")
    private String rzslid;

    /***
     * 执法人员ID
     */
    private String zfryid;

    /***
     * 执法人员姓名
     */
    private String zfryxm;

    /***
     * 执法证号
     */
    private String zfzh;

    /***
     * 执法人员入职日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date rzrq;

    /***
     * 所属单位Id
     */
    private String ssdwid;

    /***
     * 所属单位名称
     */
    private String ssdwmc;

    /***
     * 性别
     */
    private String xb;

    /***
     * 登记日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date djrq;

    /***
     * 登记人
     */
    private String djr;

    /***
     * 计划配发年份
     */
    private String jhpfnf;

    /***
     * 服装发放状态:01-正常;02-停止发放
     */
    private String fzffzt;

    /***
     * 服装停止发放原因
     */
    private String tzffyy;

    /***
     * 停止发放日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date tzffrq;

    /***
     * 备注
     */
    private String bz;

    /***
     * 入职人员服装申领登记明细信息
     */
    @TableField(exist = false)
    private String detailInfo;

    /***
     * 性别Text
     */
    @TableField(exist = false)
    private String xbText;

    /***
     * 服装发放状态Text
     */
    @TableField(exist = false)
    private String fzffztText;

    @Override
    public String getId() {
        return this.rzslid;
    }

    @Override
    public void setId(String id) {
        this.rzslid = id;
    }
}
