package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.math.BigDecimal;
import java.util.Date;

/****
 * @className FzyssbdjVo
 * @author ChrisYolanda
 * @description 执法服装预算申报登记实体类
 * @version 1.0
 * @date 2020-09-23 16:55
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFFZ_FZYSSBDJ_HIS")
public class FzyssbdjHisVo extends BaseEntity<String> {

    /***
     * 服装预算申报登记历史信息ID
     */
    @TableId("HISID")
    private String hisid;

    /***
     * 服装预算申报登记信息ID
     */
    private String fzyssbdjid;

    /******
     * 申报编号
     */
    private String sbbh;

    /******
     * 申报简述
     */
    private String sbjs;

    /******
     * 预算金额
     */
    private BigDecimal ysje;

    /******
     * 申报日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date sbrq;

    /******
     * 申报提交日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    @JSONField(format = "yyyy-MM-dd HH:mm:ss")
    private Date sbtjrq;

    /******
     * 申报备注
     */
    private String sbbz;

    /******
     * 申报人Id
     */
    private String sbrid;

    /******
     * 申报人名称
     */
    private String sbrmc;

    /******
     * 申报单位Id
     */
    private String sbdwid;

    /******
     * 申报单位名称
     */
    private String sbdwmc;

    /******
     * 接收人Id
     */
    private String jsrid;

    /******
     * 接收人名称
     */
    private String jsrmc;

    /******
     * 接收单位Id
     */
    private String jsdwid;

    /******
     * 接收单位名称
     */
    private String jsdwmc;

    /******
     * 申报状态
     */
    private String sbzt;

    /******
     * 审批状态
     */
    private String spzt;

    /*****
     * 申报登记的附件信息
     */
    @TableField("APPLY_ATTACH")
    private String applyAttach;

    /***
     * 申报状态Text
     */
    @TableField(exist = false)
    private String sbztText;

    /***
     * 审批状态Text
     */
    @TableField(exist = false)
    private String spztText;

    @Override
    public String getId() {
        return this.hisid;
    }

    @Override
    public void setId(String id) {
        this.hisid = id;
    }
}
