package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className FzsjpfxxVo
 * @author chris
 * @description 服装实际配发信息表实体类
 * @version 1.0
 * @date 2020-06-20 12:00
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFFZ_FZSJPFXX")
public class FzsjpfxxVo extends BaseEntity<String> {
    /***
     * 服装实际配发信息ID
     */
    @TableId("FZSJPFXXID")
    private String fzsjpfxxid;

    /***
     * 服装配发需求明细ID
     */
    private String fzpfxqmxid;

    /***
     * 服装实际配发编号
     */
    private String fzsjpfbh;

    /*****
     * 执法人员ID
     */
    private String zfryid;

    /***
     * 执法人员名称
     */
    private String zfrymc;

    /***
     * 执法证号
     */
    private String zfzh;

    /***
     * 执法服装品类ID
     */
    private String zffzplid;

    /***
     * 执法服装品类名称
     */
    private String zffzplmc;

    /***
     * 所属单位Id
     */
    private String ssdwid;

    /***
     * 所属单位名称
     */
    private String ssdwmc;

    /***
     * 配发数量
     */
    private String pfsl;

    /***
     * 配发需求数量
     */
    private String pfxqsl;

    /***
     * 配发年份
     */
    private String pfnf;

    /***
     * 配发类型
     * 01:首次配发（信息来源于“入职人员服装申领登记“表）
     * 02:补发（信息来源于”服装补发申领登记“表）
     * 03:到期更换（信息来源于”服装到期更换信息“表）
     */
    private String pflx;

    /*****
     * 记录时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jlsj;

    /***
     * 配发类型Text
     */
    @TableField(exist = false)
    private String pflxText;

    /***
     * 配发状态Text
     */
    @TableField(exist = false)
    private String pfztText;

    /***
     * 计量单位
     */
    @TableField(exist = false)
    private String jldw;

    /***
     * 是否列为公用
     */
    @TableField(exist = false)
    private String sflwgy;


    /***
     * 封装table数据
     */
    @TableField(exist = false)
    private String details;

    @Override
    public String getId() {
        return this.fzsjpfxxid;
    }

    @Override
    public void setId(String id) {
        this.fzsjpfxxid = id;
    }
}
