package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;

/****
 * @className FzpfxqmxVo
 * @author chris
 * @description 服装配发需求明细表实体类
 * @version 1.0
 * @date 2020-06-20 11:59
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFFZ_FZPFXQMX")
public class FzpfxqmxVo extends BaseEntity<String> {
    /***
     * 服装配发需求明细ID
     */
    @TableId("FZPFXQMXID")
    private String fzpfxqmxid;

    /***
     * 信息来源表名称
     * 第一种情况:首次配发（信息来源于“入职人员服装申领登记“表）
     * 第二种情况:补发（信息来源于”服装补发申领登记“表）
     * 第三种情况:到期更换（信息来源于”服装到期更换信息“表），该项数据以“服装到期更换信息”表中“服装到期更换信息ID”为主键，根据该主键最新的信息进行本表的信息更新。
     */
    private String xxlybmc;

    /*****
     * 信息来源表业务主键
     */
    private String xxlybywzj;

    /*****
     * 执法人员ID
     */
    private String zfryid;

    /***
     * 执法人员名称
     */
    private String zfrymc;

    /***
     * 执法证号
     */
    private String zfzh;

    /***
     * 执法服装品类ID
     */
    private String zffzplid;

    /***
     * 执法服装品类名称
     */
    private String zffzplmc;

    /***
     * 所属单位Id
     */
    private String ssdwid;

    /***
     * 所属单位名称
     */
    private String ssdwmc;

    /***
     * 性别
     */
    private String xb;

    /***
     * 配发需求数量
     */
    private String pfxqsl;

    /***
     * 配发类型：
     * 01:首次配发（信息来源于“入职人员服装申领登记“表）
     * 02:补发（信息来源于”服装补发申领登记“表）
     * 03:到期更换（信息来源于”服装到期更换信息“表）
     */
    private String pflx;

    /***
     * 计划配发年份
     */
    private String jhpfnf;

    /***
     * 计量单位
     */
    private String jldw;

    /***
     * 配发状态
     */
    private String pfzt;

    /***
     * 备注
     */
    private String bz;

    /***
     * 配发数量
     */
    @TableField(exist = false)
    private String pfsl;

    /***
     * 本次配发数量
     */
    @TableField(exist = false)
    private String bcpfsl;

    /***
     * 配发年份
     */
    @TableField(exist = false)
    private String pfnf;

    /***
     * 性别Text
     */
    @TableField(exist = false)
    private String xbText;

    /***
     * 配发类型Text
     */
    @TableField(exist = false)
    private String pflxText;
    /***
     * 配发状态Text
     */
    @TableField(exist = false)
    private String pfztText;

    /***
     * 配发人数
     */
    @TableField(exist = false)
    private String pfrs;

    /***
     * 更换标准数量
     */
    @TableField(exist = false)
    private String ghbzsl;

    /***
     * 更换标准年限
     */
    @TableField(exist = false)
    private String ghbznx;

    /***
     * 统计年份
     */
    @TableField(exist = false)
    private String tjnf;

    /***
     * 服装配发需求信息集合
     */
    @TableField(exist = false)
    private String details;

    @Override
    public String getId() {
        return this.fzpfxqmxid;
    }

    @Override
    public void setId(String id) {
        this.fzpfxqmxid = id;
    }
}
