package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className FzdqghxxVo
 * @author chris
 * @description 服装到期更换信息表实体类
 * @version 1.0
 * @date 2020-06-20 11:58
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFFZ_FZDQGHXX")
public class FzdqghxxVo extends BaseEntity<String> {
    /***
     * 服装到期更换信息ID
     */
    @TableId("FZDQGHXXID")
    private String fzdqghxxid;

    /***
     * 服装实际配发编号
     */
    private String fzsjpfbh;

    /***
     * 服装配发需求明细id
     */
    private String fzpfxqmxid;

    /***
     * 服装到期更换编号
     */
    private String fzdqghbh;

    /***
     * 执法人员ID
     */
    private String zfryid;

    /***
     * 执法人员名称
     */
    private String zfrymc;

    /***
     * 执法证号
     */
    private String zfzh;

    /***
     * 执法服装品类ID
     */
    private String zffzplid;

    /***
     * 执法服装品类名称
     */
    private String zffzplmc;

    /***
     * 更换数量
     * 生成规则：
     * 1.当服装实际配发信息更新后，结合服装品类更换标准数量生成。
     * 2.当服装补发申领信息更新并确认配发后，结合服装品类更换标准数量生成。
     */
    private String ghsl;

    /*****
     * 首次配发数量
     */
    private String scpfsl;

    /*****
     * 所属单位id
     */
    private String ssdwid;

    /*****
     * 更换年份
     */
    private String ghnf;

    /*****
     * 更换标准年限
     */
    @TableField(exist = false)
    private String ghbznx;

    /*****
     * 记录时间
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date jlsj;

    @Override
    public String getId() {
        return this.fzdqghxxid;
    }

    @Override
    public void setId(String id) {
        this.fzdqghxxid = id;
    }
}
