package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zffz.entity;

import com.alibaba.fastjson.annotation.JSONField;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import com.kdgcsoft.jt.xzzf.common.constant.DataSourceConstant;
import com.kdgcsoft.jt.xzzf.common.entity.BaseEntity;
import lombok.Data;
import org.springframework.format.annotation.DateTimeFormat;

import java.util.Date;

/****
 * @className FzbfsldjVo
 * @author chris
 * @description 服装补发申领登记实体类
 * @version 1.0
 * @date 2020-06-20 11:55
 */
@Data
@SuppressWarnings("serial")
@TableName(DataSourceConstant.DATA_SOURCE_ZBGL + "ZFZBGL_ZFFZ_FZBFSLDJ")
public class FzbfsldjVo extends BaseEntity<String> {

    /***
     * 补发申领登记ID
     */
    @TableId("BFSLDJID")
    private String bfsldjid;

    /*****
     * 补发申领编号
     */
    private String bfslbh;

    /*****
     * 执法人员Id
     */
    private String zfryid;

    /*****
     * 执法证号
     */
    private String zfzh;

    /*****
     * 执法人员姓名
     */
    private String zfryxm;

    /*****
     * 所属单位Id
     */
    private String ssdwid;

    /*****
     * 所属单位名称
     */
    private String ssdwmc;

    /*****
     * 入职日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date rzrq;

    /*****
     * 性别
     */
    private String xb;

    /*****
     * 原因说明
     */
    private String yysm;

    /*****
     * 登记日期
     */
    @DateTimeFormat(pattern = "yyyy-MM-dd")
    @JSONField(format = "yyyy-MM-dd")
    private Date djrq;

    /***
     * 登记人
     */
    private String djr;

    /***
     * 计划配发年份
     */
    private String jhpfnf;

    /***
     * 服装补发申领登记明细信息
     */
    @TableField(exist = false)
    private String detailInfo;

    /***
     * 性别Text
     */
    @TableField(exist = false)
    private String xbText;

    @Override
    public String getId() {
        return this.bfsldjid;
    }

    @Override
    public void setId(String id) {
        this.bfsldjid = id;
    }
}
