package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity.ZfclxxVo;

import java.util.List;
import java.util.Map;

/****
 * @className ZfcldjService
 * @author hufanghua
 * @description 执法车辆登记Service接口层接口
 * @version 1.0
 * @date 2020-05-30 15:03
 */
public interface ZfcldjService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @param orgId 登录人的组织机构id
     * @return
     */
    public Page<ZfclxxVo> page(Page<ZfclxxVo> page, ZfclxxVo entity,String orgId);

    /*****
     * 分页查询---指挥调度使用接口
     * @param page 分页信息
     * @param filter 查询条件
     * @param orgId 登录人的组织机构id
     * @return
     */
    public Page<ZfclxxVo> queryZhddPage(Page<ZfclxxVo> page,String filter,String orgId);

    /*****
     * 保存或修改执法车辆信息数据
     * @param entity 车辆实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(ZfclxxVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取执法车辆信息
     * @param id 主键ID
     * @return
     */
    public ZfclxxVo getEntityInfoById(String id);

    /*****
     * 删除执法车辆信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /***
     * 根据车牌号码查询车辆信息
     * @param cphm
     * @return
     */
    public ZfclxxVo getEntityInfoByCphm(String cphm);

    /***
     * 根据车辆主键查询车辆状态日志信息
     * @param id 车辆主键
     * @return
     */
    public List<ZfclxxVo> queryClztrz(String id);

    /******
     * 获取总数
     * @param cllxId 车辆类型Id
     * @return
     */
    public Integer getTotalCountByCllxId(String cllxId);

    /*****
     * 根据车牌号码修改执法车辆的示警灯使用证id
     * @param jdsyzxxid 示警灯使用证id
     * @param cphm 车牌号码
     */
    public void updateByCphm(String jdsyzxxid, String cphm);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);

    /***
     * 根据车牌号码查询车辆信息
     * @param cphm 车牌号码
     * @return
     */
    public ZfclxxVo getGlfzrxxByCphm(String cphm);

    /***
     * 根据车牌号码获取执法车辆信息
     * @param cphms 车牌号码集合
     * @param orgId 登录人的组织机构id
     * @return
     */
    public List<ZfclxxVo> queryClxxByCphm(String[] cphms,String orgId);

    /*****
     * 查询所有执法车辆的购置日期
     * @return
     */
    public List<ZfclxxVo> queryAllZfclGzrq() ;

    /*****
     * 更新年审到期日数据
     * @return
     */
    public int updateNsdqr(ZfclxxVo zfclxxVo);

    /*****
     * 根据id更新管理负责人
     * @param entity 车辆实体类
     * @return
     */
    public void updateGlfzr(ZfclxxVo entity,SysUser user);

    /*****
     * 查询车辆状态图表数据
     * @param orgId 单位id
     * @param flag 是否查询子机构标识
     * @return
     */
    public List<ZfclxxVo> queryClztEchart(String orgId,String flag);

    /*****
     * 查询车辆类型图表数据
     * @param orgId 单位id
     * @param flag 是否查询子机构标识
     * @return
     */
    public List<ZfclxxVo> queryCllxEchart(String orgId,String flag);

    /*****
     * 查询执法车辆数量
     * @param orgId 单位id
     * @param flag 是否查询子机构标识
     * @return
     */
    public ZfclxxVo queryZfclCount(String orgId,String flag);

    /*****
     * 导出查询
     * @param entity 实体类
     * @param ids 主键集合
     * @param curUserOrgId 当前登录用户组织机构Id
     * @return
     */
    public List<ZfclxxVo> export(ZfclxxVo entity, String ids, String curUserOrgId);
}
