package com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.service;

import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.kdgcsoft.jt.xzzf.common.excel.jxls.ExcelRowInfo;
import com.kdgcsoft.jt.xzzf.dubbo.system.sys.entity.SysUser;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity.SjdsyzxxVo;
import com.kdgcsoft.jt.xzzf.dubbo.zbgl.zfcl.entity.ZfclxxVo;

import java.util.List;
import java.util.Map;

/****
 * @className SjdsyzxxService
 * @author hufanghua
 * @description 示警灯使用证信息Service接口层接口
 * @version 1.0
 * @date 2020-05-30 15:03
 */
public interface SjdsyzxxService {
    /*****
     * 分页查询
     * @param page 分页信息
     * @param entity 实体类
     * @return
     */
    public Page<SjdsyzxxVo> page(Page<SjdsyzxxVo> page, SjdsyzxxVo entity,String orgId);

    /*****
     * 保存或修改示警灯使用证信息数据
     * @param entity 车辆实体类
     * @param user 当前登录用户
     * @param isCreate 是否创建
     */
    public void saveOrUpdate(SjdsyzxxVo entity, SysUser user, boolean isCreate);

    /*****
     * 获取示警灯使用证信息
     * @param id 主键ID
     * @return
     */
    public SjdsyzxxVo getEntityInfoById(String id);

    /*****
     * 删除示警灯使用证信息
     * @param ids 主键Id集合
     */
    public void deleteDataByIds(String ids, SysUser user);

    /***
     * 根据示警灯使用证编号查询示警灯使用证信息
     * @param syzbh 使用证编号
     * @return
     */
    public SjdsyzxxVo getEntityInfoBySyzbh(String syzbh);

    /***
     * 根据使用证主键查询示警灯使用证状态日志
     * @param id 使用证主键
     * @return
     */
    public List<SjdsyzxxVo> querySyzztrz(String id);

    /*****
     * 导入Excel
     * @param dataList
     * @param user
     * @return
     */
    public ExcelRowInfo importExcel(List<Map<String, Object>> dataList, SysUser user);

    /*****
     * 查询示警灯使用证数量
     * @param orgId 单位id数组
     * @return
     */
    public SjdsyzxxVo querySjdsyzCount(String orgId,String flag);

    /*****
     * 查询示警灯到期日
     * @return
     */
    public List<SjdsyzxxVo> querySjdsyzYxqz( );
}
